Attribute VB_Name = "Module2"
'**********************************************************
' Enum Constant Value
'**********************************************************



' RESULT OF FUNCTION
'
Public Enum ResultOfFunction

QCAP_RS_SUCCESSFUL								 = &H00000000

QCAP_RS_ERROR_GENERAL							 = &H00000001

QCAP_RS_ERROR_OUT_OF_MEMORY						 = &H00000002

QCAP_RS_ERROR_OUT_OF_RESOURCE					 = &H00000003

QCAP_RS_ERROR_INVALID_DEVICE					 = &H00000004

QCAP_RS_ERROR_INVALID_PARAMETER					 = &H00000005

QCAP_RS_ERROR_NON_SUPPORT						 = &H00000006

QCAP_RS_ERROR_TIMEOUT							 = &H00000007

QCAP_RS_ERROR_INVALID_ANIMATION_SCRIPT			 = &H00000008

QCAP_RS_ERROR_NO_SIGNAL_DETECTED				 = &H00000009

QCAP_RS_ERROR_NEED_MORE_DATA					 = &H0000000A

QCAP_RS_ERROR_CONNECT_FAIL						 = &H0000000B

QCAP_RS_ERROR_FILE_ACCESS_FAIL					 = &H0000000C

QCAP_RS_ERROR_NETWORK_ACCESS_FAIL				 = &H0000000D

QCAP_RS_ERROR_FILE_IS_BOX_MOVED					 = &H0000000E

QCAP_RS_ERROR_FRAME_IS_COPIED					 = &H0000000F

QCAP_RS_ERROR_VIDEO_ENCODER_ACCESS_FAIL			 = &H00000010

QCAP_RS_ERROR_AUDIO_ENCODER_ACCESS_FAIL			 = &H00000011

QCAP_RS_ERROR_NETWORK_CONNECT_UNKNOWN_FAIL		 = &H80000000

QCAP_RS_ERROR_NETWORK_CONNECT_URL_FAIL			 = &H80000001

QCAP_RS_ERROR_NETWORK_CONNECT_PASSWORD_FAIL		 = &H80000002

QCAP_RS_ERROR_NETWORK_CONNECT_SESSION_NAME_FAIL  = &H80000003

End Enum

' RETURN OF CALLBACK
'
Public Enum ReturnOfCallbackEnum

QCAP_RT_OK					 = &H00000000
	
QCAP_RT_FAIL				 = &H00000001

QCAP_RT_SKIP_RECORD_NUM_00	 = &H00010002

QCAP_RT_SKIP_RECORD_NUM_01	 = &H00020002

QCAP_RT_SKIP_RECORD_NUM_02	 = &H00040002

QCAP_RT_SKIP_RECORD_NUM_03	 = &H00080002

QCAP_RT_SKIP_DISPLAY		 = &H00000004
											  '
											  '		  PF_VIDEO_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_BROADCAST_CLIENT_CALLBACK / 
											  '
											  '		  PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK /
											  '
											  '		  PF_VIDEO_DECODER_FILE_CALLBACK / PF_AUDIO_DECODER_FILE_CALLBACK
											  
QCAP_RT_SKIP_CLONE_DISPLAY	 = &H00000008

QCAP_RT_RESET_RECORD_NUM_00	 = &H01000010

QCAP_RT_RESET_RECORD_NUM_01	 = &H02000010

QCAP_RT_RESET_RECORD_NUM_02	 = &H04000010

QCAP_RT_RESET_RECORD_NUM_03	 = &H08000010

End Enum

' DEVICE ENUMERATION TYPE
'

Public Const QCAP_ENUM_TYPE_DEVICE_NAME		 =  0

Public Const QCAP_ENUM_TYPE_SERIAL_NUMBER	 =  1

' INPUT VIDEO SOURCE
'

Public Const QCAP_INPUT_TYPE_COMPOSITE	  =  0

Public Const QCAP_INPUT_TYPE_SVIDEO		  =  1

Public Const QCAP_INPUT_TYPE_HDMI		  =  2

Public Const QCAP_INPUT_TYPE_DVI_D		  =  3

Public Const QCAP_INPUT_TYPE_COMPONENTS	  =  4

Public Const QCAP_INPUT_TYPE_YCBCR		  =  4

Public Const QCAP_INPUT_TYPE_DVI_A		  =  5

Public Const QCAP_INPUT_TYPE_RGB			  =  5

Public Const QCAP_INPUT_TYPE_VGA			  =  5

Public Const QCAP_INPUT_TYPE_SDI			  =  6

Public Const QCAP_INPUT_TYPE_DISPLAY_PORT  =  8

Public Const QCAP_INPUT_TYPE_AUTO		  =  7

' INPUT AUDIO SOURCE
'

Public Const QCAP_INPUT_TYPE_EMBEDDED_AUDIO			 =  0

Public Const QCAP_INPUT_TYPE_LINE_IN					 =  1

Public Const QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE	 =  2

Public Const QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN		 =  3

' VIDEO STANDARD TYPE
'

Public Const QCAP_STANDARD_TYPE_NTSC_M		 = &H00000001

Public Const QCAP_STANDARD_TYPE_NTSC_M_J		 = &H00000002

Public Const QCAP_STANDARD_TYPE_NTSC_433		 = &H00000004

Public Const QCAP_STANDARD_TYPE_PAL_M		 = &H00000200

Public Const QCAP_STANDARD_TYPE_PAL_60		 = &H00000800

Public Const QCAP_STANDARD_TYPE_PAL_B		 = &H00000010

Public Const QCAP_STANDARD_TYPE_PAL_D		 = &H00000020

Public Const QCAP_STANDARD_TYPE_PAL_G		 = &H00000040

Public Const QCAP_STANDARD_TYPE_PAL_H		 = &H00000080

Public Const QCAP_STANDARD_TYPE_PAL_I		 = &H00000100

Public Const QCAP_STANDARD_TYPE_PAL_N		 = &H00000400

Public Const QCAP_STANDARD_TYPE_PAL_N_COMBO	 = &H00100000

Public Const QCAP_STANDARD_TYPE_AUTO			 = &H80000000
												  '
												  '		  [P.S. SC290N4/SC390N4/N8/N16 (AH8400 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  '
												  '		  [P.S. SC2B0N4/SC3B0N4/N8/N16 (TW5864 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  '
												  '		  [P.S. SC3A0N4/N8/N16         (FH8735 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  '
												  '		  [P.S. SC3C0N4/N8/N16         (MZ0380 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]

' VIDEO DEINTERLACE TYPE
'

Public Const QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING			   = &H00000000

Public Const QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE	   = &H00000001

Public Const QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE	   = &H00000002

Public Const QCAP_SOFTWARE_DEINTERLACE_TYPE_BOB				   = &H00000003

Public Const QCAP_SOFTWARE_DEINTERLACE_TYPE_MEDICAL_RGB_REPACK  = &H00000010

' COLORRANGE TYPE
'

Public Const QCAP_COLORRANGE_TYPE_FULL		         =  0

Public Const QCAP_COLORRANGE_TYPE_LIMIT		         =  1

Public Const QCAP_COLORRANGE_TYPE_FULL_BGR32	         =  2

Public Const QCAP_COLORRANGE_TYPE_LIMIT_BGR32         =  3

Public Const QCAP_COLORRANGE_TYPE_LIMIT_ITU601        =  5

Public Const QCAP_COLORRANGE_TYPE_LIMIT_ITU601_BGR32  =  7

' COLORSPACE TYPE
'

Public Const QCAP_COLORSPACE_TYEP_RGB24	 =  0

Public Const QCAP_COLORSPACE_TYEP_BGR24	 =  1

Public Const QCAP_COLORSPACE_TYEP_ARGB32	 =  2

Public Const QCAP_COLORSPACE_TYEP_ABGR32	 =  3

Public Const QCAP_COLORSPACE_TYEP_YUY2	 = &H32595559

Public Const QCAP_COLORSPACE_TYEP_UYVY	 = &H59565955

Public Const QCAP_COLORSPACE_TYEP_YV12	 = &H32315659

Public Const QCAP_COLORSPACE_TYEP_I420	 = &H30323449

Public Const QCAP_COLORSPACE_TYEP_Y800	 = &H30303859

Public Const QCAP_COLORSPACE_TYEP_MJPG	 = &H47504A4D

Public Const QCAP_COLORSPACE_TYEP_H264	 = &H34363248

Public Const QCAP_COLORSPACE_TYEP_H265	 = &H35363248

' ENCODER TYPE (RECORD PROPERTY)
'

Public Const QCAP_ENCODER_TYPE_SOFTWARE			 =  0

Public Const QCAP_ENCODER_TYPE_HARDWARE			 =  1

Public Const QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK	 =  2

Public Const QCAP_ENCODER_TYPE_AMD_VCE			 =  3

Public Const QCAP_ENCODER_TYPE_NVIDIA_CUDA		 =  4

Public Const QCAP_ENCODER_TYPE_NVIDIA_NVENC		 =  5

' ENCODER VIDEO FORMAT (RECORD PROPERTY)
'

Public Const QCAP_ENCODER_FORMAT_MPEG2		 =   1

Public Const QCAP_ENCODER_FORMAT_H264		 =   0

Public Const QCAP_ENCODER_FORMAT_H264_3D		 =   2

Public Const QCAP_ENCODER_FORMAT_H264_VC		 =   3

Public Const QCAP_ENCODER_FORMAT_RAW			 =   4

Public Const QCAP_ENCODER_FORMAT_RAW_NATIVE	 =   4

Public Const QCAP_ENCODER_FORMAT_H265		 =   5

Public Const QCAP_ENCODER_FORMAT_RAW_YUY2	 =  20

Public Const QCAP_ENCODER_FORMAT_RAW_UYVY	 =  21

Public Const QCAP_ENCODER_FORMAT_RAW_YV12	 =  22

Public Const QCAP_ENCODER_FORMAT_RAW_I420	 =  23

Public Const QCAP_ENCODER_FORMAT_RAW_Y800	 =  24

' ENCODER AUDIO FORMAT (RECORD PROPERTY)
'

Public Const QCAP_ENCODER_FORMAT_PCM			 =  0

Public Const QCAP_ENCODER_FORMAT_AAC			 =  1

Public Const QCAP_ENCODER_FORMAT_AAC_RAW		 =  1

Public Const QCAP_ENCODER_FORMAT_AAC_ADTS	 =  2

Public Const QCAP_ENCODER_FORMAT_MP2			 =  4

Public Const QCAP_ENCODER_FORMAT_MP3			 =  5

Public Const QCAP_ENCODER_FORMAT_OPUS		 =  6

Public Const QCAP_ENCODER_FORMAT_AC3			 =  7

' RECORD PROFILE (RECORD PROPERTY)
'

Public Const QCAP_RECORD_PROFILE_BASELINE	          =  0

Public Const QCAP_RECORD_PROFILE_MAIN		          =  1

Public Const QCAP_RECORD_PROFILE_HIGH		          =  2

Public Const QCAP_RECORD_PROFILE_CONSTRAINED_BASELINE  =  3

Public Const QCAP_RECORD_PROFILE_CONSTRAINED_HIGH      =  4

' RECORD LEVEL (RECORD PROPERTY)
'

Public Const QCAP_RECORD_LEVEL_1		 =  10

Public Const QCAP_RECORD_LEVEL_1B	 =   9

Public Const QCAP_RECORD_LEVEL_11	 =  11

Public Const QCAP_RECORD_LEVEL_12	 =  12

Public Const QCAP_RECORD_LEVEL_13	 =  13

Public Const QCAP_RECORD_LEVEL_2		 =  20

Public Const QCAP_RECORD_LEVEL_21	 =  21

Public Const QCAP_RECORD_LEVEL_22	 =  22

Public Const QCAP_RECORD_LEVEL_3		 =  30

Public Const QCAP_RECORD_LEVEL_31	 =  31

Public Const QCAP_RECORD_LEVEL_32	 =  32

Public Const QCAP_RECORD_LEVEL_4		 =  40

Public Const QCAP_RECORD_LEVEL_41	 =  41

Public Const QCAP_RECORD_LEVEL_42	 =  42

Public Const QCAP_RECORD_LEVEL_50	 =  50

Public Const QCAP_RECORD_LEVEL_51	 =  51

Public Const QCAP_RECORD_LEVEL_52	 =  52

Public Const QCAP_RECORD_LEVEL_60	 =  60

Public Const QCAP_RECORD_LEVEL_61	 =  61

Public Const QCAP_RECORD_LEVEL_62	 =  62

' RECORD ENTROPY (RECORD PROPERTY)
'

Public Const QCAP_RECORD_ENTROPY_CAVLC	 =  0

Public Const QCAP_RECORD_ENTROPY_CABAC	 =  1

' RECORD COMPLEXITY (RECORD PROPERTY)
'

Public Const QCAP_RECORD_COMPLEXITY_0	 =  0

Public Const QCAP_RECORD_COMPLEXITY_1	 =  1

Public Const QCAP_RECORD_COMPLEXITY_2	 =  2

Public Const QCAP_RECORD_COMPLEXITY_3	 =  3

Public Const QCAP_RECORD_COMPLEXITY_4	 =  4

Public Const QCAP_RECORD_COMPLEXITY_5	 =  5

Public Const QCAP_RECORD_COMPLEXITY_6	 =  6

' RECORD MODE (RECORD PROPERTY)
'

Public Const QCAP_RECORD_MODE_VBR		 =  0

Public Const QCAP_RECORD_MODE_CBR		 =  1

Public Const QCAP_RECORD_MODE_ABR		 =  2

Public Const QCAP_RECORD_MODE_CQP		 =  3

Public Const QCAP_RECORD_MODE_LOSSLESS	 =  4

' DOWNSCALE MODE (RECORD PROPERTY)
' 

Public Const QCAP_DOWNSCALE_MODE_OFF	 =  0

Public Const QCAP_DOWNSCALE_MODE_2_3	 =  1

Public Const QCAP_DOWNSCALE_MODE_1_2	 =  2

Public Const QCAP_DOWNSCALE_MODE_1_4	 =  3

' RECORD FLAG (RECORD PROPERTY)
'

Public Const QCAP_RECORD_FLAG_FULL						 = &H00000007

Public Const QCAP_RECORD_FLAG_FILE						 = &H00000001

Public Const QCAP_RECORD_FLAG_ENCODE						 = &H00000002

Public Const QCAP_RECORD_FLAG_DISPLAY					 = &H00000004

Public Const QCAP_RECORD_FLAG_DECODE						 = &H00000008

Public Const QCAP_RECORD_FLAG_VIDEO_ONLY					 = &H00000010

Public Const QCAP_RECORD_FLAG_AUDIO_ONLY					 = &H00000020

Public Const QCAP_RECORD_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	 = &H00000040

Public Const QCAP_RECORD_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	 = &H00000080

Public Const QCAP_RECORD_FLAG_INGNORE_FORMAT_CHANGED		 = &H00000100

Public Const QCAP_RECORD_FLAG_SYNCHRONIZED_RECORD		 = &H00000200

Public Const QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER		 = &H00000400

Public Const QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER		 = &H00000800

' BROADCAST FLAG (BROADCAST PROPERTY)
'

Public Const QCAP_BROADCAST_FLAG_FULL						 = &H00000007

Public Const QCAP_BROADCAST_FLAG_NETWORK						 = &H00000001

Public Const QCAP_BROADCAST_FLAG_ENCODE						 = &H00000002

Public Const QCAP_BROADCAST_FLAG_DISPLAY						 = &H00000004

Public Const QCAP_BROADCAST_FLAG_DECODE						 = &H00000008

Public Const QCAP_BROADCAST_FLAG_VIDEO_ONLY					 = &H00000010
	
Public Const QCAP_BROADCAST_FLAG_AUDIO_ONLY					 = &H00000020

Public Const QCAP_BROADCAST_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	 = &H00000040

Public Const QCAP_BROADCAST_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	 = &H00000080

Public Const QCAP_BROADCAST_FLAG_VIDEO_USE_MEDIA_TIMER		 = &H00000400

Public Const QCAP_BROADCAST_FLAG_AUDIO_USE_MEDIA_TIMER		 = &H00000800

' BROADCAST PROTOCOL (BROADCAST PROPERTY)
'

Public Const QCAP_BROADCAST_PROTOCOL_UDP	  = &H00000000

Public Const QCAP_BROADCAST_PROTOCOL_TCP	  = &H00000001

Public Const QCAP_BROADCAST_PROTOCOL_HTTP  = &H00000002

' OSD FONT STYLE (OSD PROPERTY)
'

Public Const QCAP_FONT_STYLE_REGULAR      = &H00000000
    
Public Const QCAP_FONT_STYLE_BOLD         = &H00000001
    
Public Const QCAP_FONT_STYLE_ITALIC       = &H00000002
    
Public Const QCAP_FONT_STYLE_BOLDITALIC   = &H00000003
    
Public Const QCAP_FONT_STYLE_UNDERLINE    = &H00000004
    
Public Const QCAP_FONT_STYLE_STRIKEOUT    = &H00000008

' OSD STRING ALIGNMENT (OSD PROPERTY)
'

Public Const QCAP_STRING_ALIGNMENT_STYLE_LEFT     = &H00000000

Public Const QCAP_STRING_ALIGNMENT_STYLE_NEAR     = &H00000000
    
Public Const QCAP_STRING_ALIGNMENT_STYLE_CENTER   = &H00000001
    
Public Const QCAP_STRING_ALIGNMENT_STYLE_RIGHT    = &H00000002
    
Public Const QCAP_STRING_ALIGNMENT_STYLE_FAR		 = &H00000002

' OSD SEQUENCE STYLE (OSD PROPERTY)
'

	'  GENERAL DEVICE: FOREMOST -> PREVIEW CALLBACK -> BEFORE_ENCODE -> RECORDING (ENCODING) -> AFTERMOST
	'
	' SHARE RECORDING: FOREMOST -> RECORDING (ENCODING) -> AFTERMOST
	'
	' SHARE STREAMING: FOREMOST -> STREAMING (ENCODING) -> AFTERMOST
	'
	'  VIRTUAL CAMERA: FOREMOST -> AFTERMOST -> SHARING
	'
	'   FILE PLAYBACK: PLAYBACK (DECODING) -> FOREMOST -> DECODER CALLBACK -> AFTERMOST
	'
Public Const QCAP_SEQUENCE_STYLE_FOREMOST		 = &H00000000

Public Const QCAP_SEQUENCE_STYLE_BEFORE_ENCODE	 = &H00000001
    
Public Const QCAP_SEQUENCE_STYLE_AFTERMOST		 = &H00000002

' BUFFER SCALE STYLE (BUFFER PROPERTY)
'

Public Const QCAP_SCALE_STYLE_STRETCH	 = &H00000000

Public Const QCAP_SCALE_STYLE_FIT		 = &H00000001
    
Public Const QCAP_SCALE_STYLE_FILL		 = &H00000002

' DECODER TYPE (PLAYBACK PROPERTY)
'

Public Const QCAP_DECODER_TYPE_SOFTWARE			 =  0

Public Const QCAP_DECODER_TYPE_HARDWARE			 =  1

Public Const QCAP_DECODER_TYPE_INTEL_MEDIA_SDK	 =  2

Public Const QCAP_DECODER_TYPE_AMD_UVD			 =  3

Public Const QCAP_DECODER_TYPE_AMD_VCE			 =  3

Public Const QCAP_DECODER_TYPE_NVIDIA_CUDA		 =  4

Public Const QCAP_DECODER_TYPE_NVIDIA_NVDEC		 =  5

Public Const QCAP_DECODER_TYPE_NVIDIA_NVENC		 =  5

' DECODER VIDEO FORMAT (PLAYBACK PROPERTY)
'

Public Const QCAP_DECODER_FORMAT_MPEG2		 =   1

Public Const QCAP_DECODER_FORMAT_H264		 =   0

Public Const QCAP_DECODER_FORMAT_H264_3D		 =   2

Public Const QCAP_DECODER_FORMAT_H264_VC		 =   3

Public Const QCAP_DECODER_FORMAT_RAW			 =   4

Public Const QCAP_DECODER_FORMAT_H265		 =   5

' 3D STEREO BUFFER TYPE
'

Public Const QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE		 =  0

Public Const QCAP_3D_STEREO_BUFFER_TOP_BOTTOM		 =  1

Public Const QCAP_3D_STEREO_BUFFER_LINE_BY_LINE		 =  2

' 3D STEREO DISPLAY MODE
'

Public Const QCAP_3D_STEREO_DISPLAY_MODE_SIDE_BY_SIDE	 =  0

Public Const QCAP_3D_STEREO_DISPLAY_MODE_TOP_BOTTOM		 =  1

Public Const QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE	 =  2

Public Const QCAP_3D_STEREO_DISPLAY_MODE_LEFT_ONLY		 =  3

Public Const QCAP_3D_STEREO_DISPLAY_MODE_RIGHT_ONLY		 =  4

' FILE TIMEUNIT
'

Public Const QCAP_FILE_TIMEUNIT_TIME		 =  0

Public Const QCAP_FILE_TIMEUNIT_FRAME	 =  1

' SERIAL PORT PARITY CHECK (SERIAL PORT PROPERTY)
'

Public Const QCAP_SERIAL_PORT_PARITY_CHECK_NONE	 = &H00000000

Public Const QCAP_SERIAL_PORT_PARITY_CHECK_ODD	 = &H00000001

Public Const QCAP_SERIAL_PORT_PARITY_CHECK_EVEN	 = &H00000002

Public Const QCAP_SERIAL_PORT_PARITY_CHECK_MARK	 = &H00000003

Public Const QCAP_SERIAL_PORT_PARITY_CHECK_SPACE	 = &H00000004

' SERIAL PORT FLOW CONTROL (SERIAL PORT PROPERTY)
'

Public Const QCAP_SERIAL_PORT_FLOW_CONTROL_NONE		 = &H00000000

Public Const QCAP_SERIAL_PORT_FLOW_CONTROL_CTS_RTS	 = &H00000001

Public Const QCAP_SERIAL_PORT_FLOW_CONTROL_CTS_DTR	 = &H00000002

Public Const QCAP_SERIAL_PORT_FLOW_CONTROL_DSR_RTS	 = &H00000003

Public Const QCAP_SERIAL_PORT_FLOW_CONTROL_DSR_DTR	 = &H00000004

Public Const QCAP_SERIAL_PORT_FLOW_CONTROL_XON_XOFF	 = &H00000005

' SERIAL PORT STOP BITS (SERIAL PORT PROPERTY)
'

Public Const QCAP_SERIAL_PORT_STOP_BITS_ONE				 = &H00000000

Public Const QCAP_SERIAL_PORT_STOP_BITS_ONE_POINT_FIVE	 = &H00000001

Public Const QCAP_SERIAL_PORT_STOP_BITS_TWO				 = &H00000002

' SERIAL PORT SIGNAL TYPE (SERIAL PORT PROPERTY)
'

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_DTR		 = &H00000000

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_RTS		 = &H00000001

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_DTR		 = &H00000002

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_RTS		 = &H00000003

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_XOFF		 = &H00000004

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_XON		 = &H00000005

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_BREAK		 = &H00000006

Public Const QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_BREAK	 = &H00000007

' CALLBACK FUNCTION TYPES //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function PF_NO_SIGNAL_DETECTED_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_SIGNAL_REMOVED_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_FORMAT_CHANGED_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal nVideoWidth As Long, ByVal nVideoHeight As Long, ByVal bVideoIsInterleaved As Boolean, ByVal dVideoFrameRate As Double, ByVal nAudioChannels As Long, ByVal nAudioBitsPerSample As Long, ByVal nAudioSampleFrequency As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_FORMAT_CHANGED_CALLBACK_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal nVideoWidth As Long, ByVal nVideoHeight As Long, ByVal bVideoIsInterleaved As Boolean, ByVal dVideoNativeFrameRate As Double, ByVal dVideoGrabFrameRate As Double, ByVal nAudioChannels As Long, ByVal nAudioBitsPerSample As Long, ByVal nAudioSampleFrequency As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_SNAPSHOT_DONE_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_RECORD_DONE_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_RECORD_FAIL_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String ) As ReturnOfCallbackEnum 

Public Declare Function PF_SHARE_RECORD_DONE_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_SHARE_RECORD_FAIL_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String ) As ReturnOfCallbackEnum 

Public Declare Function PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_PREVIEW_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_PREVIEW_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_HARDWARE_ENCODER_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_MEDIA_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_MX_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_MEDIA_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal dDelayTime As Double, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

Public Declare Function PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal dDelayTime As Double, ByVal pUserData   As Long ) As ReturnOfCallbackEnum 

' CALLBACK FUNCTIONS PART.I (EVENT) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
' 
Public Declare Function QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_FORMAT_CHANGED_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_RECORD_DONE_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_RECORD_FAIL_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

' CALLBACK FUNCTIONS PART.II (DATA) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
' 
Public Declare Function QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

' CALLBACK FUNCTIONS PART.III (DATA) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
' 
Public Declare Function QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

' CALLBACK FUNCTIONS PART.IIII (DATA) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_REGISTER_VIDEO_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_MEDIA_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

Public Declare Function QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData   As Long ) As ResultOfFunction 

'' SYSTEM FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_GET_VERSION Lib "QCAP.X86.DLL" (ByRef pMajorVersion As Long, ByRef pMinorVersion   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_SYSTEM_CONFIGURATION Lib "QCAP.X86.DLL"( Optional ByVal   bEnableMultipleUsersAccess  As Boolean = 1,  Optional ByVal   bEnableVideoPreviewDevice  As Boolean = 1,  Optional ByVal   bEnableAudioPreviewDevice  As Boolean = 1,  Optional ByVal   bEnableVideoHardwareMainEncoderDevice  As Boolean = 1,  Optional ByVal   bEnableVideoHardwareSubEncoderDevice  As Boolean = 1,  Optional ByVal  nAutoInputDetectionTimeout  As Long = 3000,  Optional ByVal   bEnableSCF  As Boolean = 0,  Optional ByVal pszDB3  As String = "",  Optional ByVal   bEnableAsyncBackgroundSnapshot  As Boolean = 0 _
,  Optional ByVal   bEnableEnhancedVideoRenderer  As Boolean = 1,  Optional ByVal   bEnableSystemTimeCallback  As Boolean = 0,  Optional ByVal   bEnableFileRepairFunction  As Boolean = 1,  Optional ByVal   bEnableNewRTSPLibrary  As Boolean = 1,  Optional ByVal pszWebServerRootFolderPath  As String = "",  Optional ByVal pszWebServerIP  As String = "",  Optional ByVal  nSystemColorRangeType  As Long = QCAP_COLORRANGE_TYPE_FULL,  Optional ByVal   bEnableVideoMixingRendererBugPatch  As Boolean = 1 _
,  Optional ByVal   bEnableDirect3DVideoRenderer  As Boolean = 0 ) As ResultOfFunction 
'
Public Declare Function QCAP_QUERY_ENCODER_TYPE_CAP Lib "QCAP.X86.DLL" (ByVal nEncoderType As Long, ByVal nEncoderFormat   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_QUERY_DECODER_TYPE_CAP Lib "QCAP.X86.DLL" (ByVal nDecoderType As Long, ByVal nDecoderFormat   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_QUERY_ENCODER_STATUS Lib "QCAP.X86.DLL" (ByVal nEncoderType As Long, ByRef pExistInstances   As Long ) As ResultOfFunction 
'
'' DEVICE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_DEVICE_ENUMERATION Lib "QCAP.X86.DLL" (ByRef ppVideoDeviceList As Long, ByRef pVideoDeviceSize As Long, ByRef ppVideoEncoderDeviceList As Long, ByRef pVideoEncoderDeviceSize As Long, ByRef ppAudioDeviceList As Long, ByRef pAudioDeviceSize As Long, ByRef ppAudioEncoderDeviceList As Long, ByRef pAudioEncoderDeviceSize As Long, ByVal nDeviceEnumType  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO Lib "QCAP.X86.DLL" (ByVal iDevNum As Long, ByVal pDeviceList As Long, ByRef pDeviceInfoH As Long, ByRef pDeviceInfoL   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_CREATE Lib "QCAP.X86.DLL" (ByVal pszDevName As String, ByVal iDevNum As Long, ByVal hAttachedWindow As Long, ByRef ppDevice As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
'' DEVICE NAME TABLE:
''
'' "DC1150 USB" IS FOR PD652, PD652.3D
''
'' "QP0204 USB" IS FOR PD5A0
''
'' "UB658G USB" IS FOR UB658
''
'' "CY3014 USB" IS FOR UB530
''
'' "UB3200 USB" IS FOR PD560
''
'' "UB3300 USB" IS FOR PD570
''
'' "TW6802 PCI" IS FOR SC200, SC300, SC230, SC330
''
'' "CX2581 PCI" IS FOR SC310, SC340
''
'' "CX2385 PCI" IS FOR SC350
''
'' "AH8400 PCI" IS FOR SC290, SC390
''
'' "FH8735 PCI" IS FOR SC2A0, SC3A0
''
'' "TW5864 PCI" IS FOR SC2B0, SC3B0
''
'' "MZ0380 PCI" IS FOR SC3C0
''
'' "SA7160 PCI" IS FOR SC500, SC510, TB510
''
'' "FH8735 PCI" IS FOR SC580
''
'' "TW2809 PCI" IS FOR SC590
''
'' "QP0203 PCI" IS FOR SC540, SC5A0
''
'' "MZ0380 PCI" IS FOR SC350, SC3C0, SC550, SC560, SC5C0
''
''     "CAMERA" IS FOR GENERAL USB CAMERA
''
''  "SOUNDCARD" IS FOR GENERAL SOUND CARD
''
''    "DESKTOP" IS FOR GENERAL DESKTOP SCREEN GRABBER
'
Public Declare Function QCAP_DESTROY Lib "QCAP.X86.DLL" (ByVal pDevice   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_RUN Lib "QCAP.X86.DLL" (ByVal pDevice   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_RUN_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal bStopAfterSignalRemoved  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP Lib "QCAP.X86.DLL" (ByVal pDevice   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_QUERY_DEVICE_CAP Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pDeviceSerialNumber As Long, ByVal pszDeviceSystemPath As String, ByRef pHasHardwareMainEncoder As Boolean, ByRef pHasHardwareSubEncoder   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_INPUT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pInput   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_INPUT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nInput   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_INPUT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pInput   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_INPUT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nInput   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_STANDARD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pStandard   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_STANDARD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nStandard   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pStatus   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pIsInterleaved As Boolean, ByRef pFrameRate   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pIsInterleaved As Boolean, ByRef pNativeFrameRate As Double, ByRef pGrabFrameRate   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pIsInterleaved As Boolean, ByRef pFrameRate   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bIsInterleaved As Boolean, ByVal dFrameRate   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pLines   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nLines   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_DEINTERLACE_TYPE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pType   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_DEINTERLACE_TYPE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nType   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_DEINTERLACE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pEnable   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_DEINTERLACE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal bEnable   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_REGION_DISPLAY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_REGION_DISPLAY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_MIRROR Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pHorizontalMirror As Boolean, ByRef pVerticalMirror   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_MIRROR Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_CONTRAST Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_CONTRAST Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_HUE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_HUE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SATURATION Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SATURATION Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARPNESS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARPNESS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_BRIGHTNESS_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pPhysicalValue  As Long, ByRef pDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_BRIGHTNESS_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nPhysicalValue  As Long, ByVal nDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_CONTRAST_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pPhysicalValue  As Long, ByRef pDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_CONTRAST_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nPhysicalValue  As Long, ByVal nDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_HUE_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pPhysicalValue  As Long, ByRef pDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_HUE_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nPhysicalValue  As Long, ByVal nDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SATURATION_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pPhysicalValue  As Long, ByRef pDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SATURATION_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nPhysicalValue  As Long, ByVal nDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARPNESS_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pPhysicalValue  As Long, ByRef pDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARPNESS_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nPhysicalValue  As Long, ByVal nDisplayValue    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pDownscaleMode   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nDownscaleMode   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderFormat As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pDownscaleMode As Long, ByRef pPostSkipFrameRate  As Long, ByRef pPostAvgFrameRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nEncoderFormat As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   nDownscaleMode As Long, ByVal   nPostSkipFrameRate   As Long, ByVal   nPostAvgFrameRate     As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderFormat As Long, ByRef pRecordProfile As Long, ByRef pRecordLevel As Long, ByRef pRecordEntropy As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames As Long, ByRef pIsInterleaved As Boolean, ByRef pSlices As Long, ByRef pLayers As Long, ByRef pSceneCut As Long, ByRef pMultiThread As Boolean, ByRef pMBBRC As Boolean, ByRef pExtBRC As Boolean, ByRef pMinQP  As Long, ByRef pMaxQP  As Long _
, ByRef pVBVMaxRate  As Long, ByRef pVBVBufSize  As Long, ByRef pCBRVariation  As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long, ByRef pDstW As Long, ByRef pDstH As Long, ByRef pPostSkipFrameRate  As Long, ByRef pPostAvgFrameRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nEncoderFormat As Long, ByVal   nRecordProfile  As Long, ByVal   nRecordLevel  As Long, ByVal   nRecordEntropy  As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nBFrames  As Long, ByVal   bIsInterleaved  As Boolean, ByVal   nSlices  As Long, ByVal   nLayers  As Long, ByVal   nSceneCut As Long, ByVal   bMultiThread As Boolean, ByVal   bMBBRC As Boolean, ByVal   bExtBRC As Boolean _
, ByVal   nMinQP   As Long, ByVal   nMaxQP   As Long, ByVal   nVBVMaxRate   As Long, ByVal   nVBVBufSize   As Long, ByVal   nCBRVariation   As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   nCropX As Long, ByVal   nCropY As Long, ByVal   nCropW As Long, ByVal   nCropH As Long, ByVal   nDstW As Long, ByVal   nDstH As Long, ByVal   nPostSkipFrameRate   As Long, ByVal   nPostAvgFrameRate     As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nProperty As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nProperty As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_VOLUME Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pVolume   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_VOLUME Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nVolume   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_DEVICE_CUSTOM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_DEVICE_CUSTOM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByVal pValue As Long, ByVal nBytes   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByVal pValue As Long, ByVal nBytes   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DIAGNOSE_VIDEO_STREAM_STATUS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pIsStill As Boolean, ByVal nStillThreshold  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DIAGNOSE_AUDIO_STREAM_STATUS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pVolumeDB_L  As Double, ByRef pVolumeDB_R    As Double ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( PVOID pDevice , PF_NO_SIGNAL_DETECTED_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( PVOID pDevice , PF_SIGNAL_REMOVED_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( PVOID pDevice , PF_FORMAT_CHANGED_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX( PVOID pDevice , PF_FORMAT_CHANGED_CALLBACK_EX pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK( PVOID pDevice , PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK pCB , PVOID pUserData  ); ' VANC
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( PVOID pDevice , PF_VIDEO_PREVIEW_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( PVOID pDevice , PF_AUDIO_PREVIEW_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( PVOID pDevice , UINT iRecNum , PF_VIDEO_HARDWARE_ENCODER_CALLBACK pCB , PVOID pUserData  );
'
'' LOCK/UNLOCK FUNCTIONS (FOR LABVIEW 2010/2012 DEVELOPER) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_COPY_VIDEO_PREVIEW_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double, ByVal nColorSpaceType As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_COPY_AUDIO_PREVIEW_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_LOCK_VIDEO_PREVIEW_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_LOCK_AUDIO_PREVIEW_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice   As Long ) As ResultOfFunction 
'
'' SNAPSHOT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_SNAPSHOT_BMP Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_JPG Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_BMP_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_JPG_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK( PVOID pDevice , PF_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK( PVOID pDevice , PF_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );
'
'' CHANNEL RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS CHANNEL RECORDING) (RECNUM: 0 ~ 3) /////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_GET_VIDEO_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pDownscaleMode   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   nDownscaleMode    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pRecordProfile  As Long, ByRef pRecordLevel  As Long, ByRef pRecordEntropy  As Long, ByRef pRecordComplexity  As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames  As Long, ByRef pIsInterleaved  As Boolean, ByRef pSlices  As Long, ByRef pLayers  As Long, ByRef pSceneCut  As Long, ByRef pMultiThread  As Boolean, ByRef pMBBRC  As Boolean _
, ByRef pExtBRC  As Boolean, ByRef pMinQP  As Long, ByRef pMaxQP  As Long, ByRef pVBVMaxRate  As Long, ByRef pVBVBufSize  As Long, ByRef pCBRVariation  As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long, ByRef pDstW As Long, ByRef pDstH As Long, ByRef pPostSkipFrameRate  As Long, ByRef pPostAvgFrameRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nRecordProfile   As Long, ByVal   nRecordLevel   As Long, ByVal   nRecordEntropy   As Long, ByVal   nRecordComplexity   As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nBFrames   As Long, ByVal   bIsInterleaved   As Boolean, ByVal   nSlices   As Long, ByVal   nLayers   As Long, ByVal   nSceneCut   As Long, ByVal   bMultiThread   As Boolean _
, ByVal   bMBBRC   As Boolean, ByVal   bExtBRC   As Boolean, ByVal   nMinQP   As Long, ByVal   nMaxQP   As Long, ByVal   nVBVMaxRate   As Long, ByVal   nVBVBufSize   As Long, ByVal   nCBRVariation   As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   nCropX As Long, ByVal   nCropY As Long, ByVal   nCropW As Long, ByVal   nCropH As Long, ByVal   nDstW As Long, ByVal   nDstH As Long, ByVal   nPostSkipFrameRate   As Long, ByVal   nPostAvgFrameRate     As Long _
 ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pBitRate   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nBitRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_METADATA_RECORD_HEADER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszTitle As String, ByVal pszArtist As String, ByVal pszComments As String, ByVal pszGenre As String, ByVal pszComposer   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_METADATA_RECORD_HEADER_W Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_METADATA_RECORD_DATA_BUFFER Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pDataBuffer As Long, ByVal nDataBufferSize As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_START_CLONE_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathNameA As String, ByVal pszFilePathNameB As String, ByVal dwFlags As Long, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime As Double, ByVal dSegmentDurationTime As Double, ByVal nSegmentDurationSizeKB  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_TIMESHIFT_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String, ByRef ppPhysicalFileWriter As Long, ByVal dwFlags As Long, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_START_FAILSAFE_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal iLinkRecNum As Long, ByVal pLinkPhysicalFileWriter As Long, ByVal dPreRecordTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_START_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal dwFlags As Long, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime As Double, ByVal dSegmentDurationTime As Double, ByVal nSegmentDurationSizeKB  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_RESUME_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_PAUSE_RECORD Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iRecNum   As Long ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_DONE_CALLBACK(  PVOID pDevice , UINT iRecNum , PF_RECORD_DONE_CALLBACK  pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_FAIL_CALLBACK(  PVOID pDevice , UINT iRecNum , PF_RECORD_FAIL_CALLBACK  pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_RECORD_CALLBACK( PVOID pDevice , UINT iRecNum , PF_VIDEO_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_RECORD_CALLBACK( PVOID pDevice , UINT iRecNum , PF_AUDIO_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_RECORD_CALLBACK( PVOID pDevice , UINT iRecNum , PF_MEDIA_RECORD_CALLBACK pCB , PVOID pUserData  ); ' ONLY FOR TS & FLV FILE FORMAT
'
'' CLONE FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_CREATE_CLONE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal hAttachedWindow As Long, ByRef ppCloneDevice As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
'' OSD FUNCTIONS (SUPPORT MULTIPLE-LAYERS OSD OBJECTS) (OSDNUM: 0 ~ 511) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
''
Public Declare Function QCAP_MOVE_OSD_OBJECT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_OSD_TEXT_BOUNDARY Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_OSD_TEXT_BOUNDARY_W Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_TEXT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_TEXT_W Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_TEXT_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nStringAlignmentStyle As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double _
 ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_TEXT_EX_W Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_PICTURE Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_BUFFER Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long _
, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_BUFFER_EX Lib "QCAP.X86.DLL" _
(ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long _
, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
'' MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) //////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_CREATE_SYNCHRONIZED_RECORD Lib "QCAP.X86.DLL" (ByRef ppSyncRecorder As Long, ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_SYNCHRONIZED_RECORD Lib "QCAP.X86.DLL" (ByVal pSyncRecorder   As Long ) As ResultOfFunction 
'
'
'
'' SYNCHRONIZED RECORDING EXAMPLE
''
'' QCAP_CREATE_SYNCHRONIZED_RECORD( &pSyncRecorder, 4, "SR_CH01.MP4", pDevices[ 0 ], 0, 
''
''								                       "SR_CH02.MP4", pDevices[ 1 ], 0, 
''
''								                       "SR_CH03.MP4", pDevices[ 2 ], 0, 
''
''								                       "SR_CH04.MP4", pDevices[ 3 ], 0 );
''
'' 
'' QCAP_DESTROY_SYNCHRONIZED_RECORD( pSyncRecorder );
'' 
'' CAMERA FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_CAMERA_ENUMERATION Lib "QCAP.X86.DLL" (ByRef ppszCameraDevName As String, ByVal bNext  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_CAMERA_ENUMERATION_W Lib "QCAP.X86.DLL" QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CAMERA_ENUMERATION_W( WSTRING * ppwszCameraDevName , BOOL bNext = FALSE  ); ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_DEFAULT_CAMERA Lib "QCAP.X86.DLL" (ByVal pszCameraDevName   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_CAMERA_COUNT_OF_SUPPORT_OUTPUT_FORMATS Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByRef pCount   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_CAMERA_SUPPORT_OUTPUT_FORMAT Lib "QCAP.X86.DLL" (ByVal pDevice As Long, ByVal iFmtNum As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pIsInterleaved As Boolean, ByRef pFrameRate   As Double ) As ResultOfFunction 
'
'' CAMERA EXAMPLE:
'' 
'' STEP#01 QCAP_CREATE( "CAMERA", 0, hWindow, &pDevice, TRUE );
'' 
'' STEP#03 QCAP_RUN( pDevice );
'' 
'' STEP#04 QCAP_STOP( pDevice );
'' 
'' STEP#05 QCAP_DESTROY( pDevice );
'
'' SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_GET_SHARE_RECORD_STATUS Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pIsValid   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pAttachedWindow As Long, ByRef pThumbDraw As Boolean, ByRef pMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nColorSpaceType As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate As Double, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   hAttachedWindow As Long, ByVal   bThumbDraw As Boolean, ByVal   bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordProfile  As Long, ByRef pRecordLevel  As Long, ByRef pRecordEntropy  As Long, ByRef pRecordComplexity  As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames  As Long, ByRef pIsInterleaved  As Boolean, ByRef pSlices  As Long, ByRef pLayers  As Long _
, ByRef pSceneCut  As Long, ByRef pMultiThread  As Boolean, ByRef pMBBRC  As Boolean, ByRef pExtBRC  As Boolean, ByRef pMinQP  As Long, ByRef pMaxQP  As Long, ByRef pVBVMaxRate  As Long, ByRef pVBVBufSize  As Long, ByRef pCBRVariation  As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pAttachedWindow As Long, ByRef pThumbDraw As Boolean, ByRef pMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nColorSpaceType As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate As Double, ByVal   nRecordProfile   As Long, ByVal   nRecordLevel   As Long, ByVal   nRecordEntropy   As Long, ByVal   nRecordComplexity   As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nBFrames   As Long, ByVal   bIsInterleaved   As Boolean _
, ByVal   nSlices   As Long, ByVal   nLayers   As Long, ByVal   nSceneCut   As Long, ByVal   bMultiThread   As Boolean, ByVal   bMBBRC   As Boolean, ByVal   bExtBRC   As Boolean, ByVal   nMinQP   As Long, ByVal   nMaxQP   As Long, ByVal   nVBVMaxRate   As Long, ByVal   nVBVBufSize   As Long, ByVal   nCBRVariation   As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   hAttachedWindow As Long, ByVal   bThumbDraw As Boolean, ByVal   bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_COPP Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pEnable   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_COPP Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   bEnable    As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_CONTRAST Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_CONTRAST Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_HUE Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_HUE Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_SATURATION Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_SATURATION Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency As Long, ByVal   nBitRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_SHARE_RECORD_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   iSoundNum    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_SHARE_RECORD_VOLUME Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pVolume   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_VOLUME Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   nVolume    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle As Long, ByVal bForceKeyFrame As Boolean, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_METADATA_SHARE_RECORD_HEADER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszTitle As String, ByVal pszArtist As String, ByVal pszComments As String, ByVal pszGenre As String, ByVal pszComposer   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_METADATA_SHARE_RECORD_HEADER_W Lib "QCAP.X86.DLL" (ByVal iRecNum As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_METADATA_SHARE_RECORD_DATA_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pDataBuffer As Long, ByVal nDataBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_START_TIMESHIFT_SHARE_RECORD Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByRef ppPhysicalFileWriter As Long, ByVal dwFlags As Long, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_START_SHARE_RECORD Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal dwFlags As Long, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime As Double, ByVal dSegmentDurationTime As Double, ByVal nSegmentDurationSizeKB  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_SHARE_RECORD Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_RESUME_SHARE_RECORD Lib "QCAP.X86.DLL" (ByVal iRecNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_PAUSE_SHARE_RECORD Lib "QCAP.X86.DLL" (ByVal iRecNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_BMP Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_JPG Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_MOVE_OSD_SHARE_RECORD_OBJECT Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY_W Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_TEXT Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_TEXT_W Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_TEXT_EX Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nStringAlignmentStyle As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double _
 ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_TEXT_EX_W Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_PICTURE Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_BUFFER Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long _
, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_OSD_SHARE_RECORD_BUFFER_EX Lib "QCAP.X86.DLL" _
(ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long _
, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK( UINT iRecNum , PF_SHARE_RECORD_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK( UINT iRecNum , PF_SHARE_RECORD_FAIL_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK( UINT iRecNum , PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK( UINT iRecNum , PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_VIDEO_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_AUDIO_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_MEDIA_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  ); ' ONLY FOR TS & FLV FILE FORMAT
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( UINT iRecNum , PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( UINT iRecNum , PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );
'
'' VIDEO 3D SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) ///////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nStereoBufferType  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle As Long, ByVal nStereoBufferType  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal nStereoDisplayMode As Long, ByVal bLeftRightSwap As Boolean, ByVal bForceKeyFrame As Boolean, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
'' AUDIO MIXING/TRACKS SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) (TRACKNUM: 0 ~ 3) //////////////////////////////////////////////////////////////////////
''
Public Declare Function QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByRef pTracks As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal   nTracks As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency As Long, ByVal   nBitRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal iMixNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal iMixNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_AUDIO_MX_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK( UINT iRecNum , PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # BROADCASTING SERVER FUNCTIONS (RTSP/RTMP/HLS/TS/MMS) (2D/3D)
'' #
'' ##########################################################################################################################################################################################
''
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK)( PVOID pServer , UINT iSessionNum , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer , UINT iSessionNum , UINT iTrackNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , double dDelayTime , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer , UINT iSessionNum , double dSampleTime , double dDelayTime , PVOID pUserData  );
'
Public Declare Function  QCAP_GET_BROADCAST_SERVER_STATUS Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByRef pIsValid   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_RTSP_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword As String, ByVal nNetworkPort_RTSP As Long, ByVal nNetworkPort_RTSPOverHTTP As Long, ByVal bEnableMulticasting As Boolean, ByVal bEnableUltraLowLatency  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_RTSP_RAW_UDP_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword As String, ByVal nNetworkPort_RTSP  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_HLS_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, ByVal pszWebServerRootFolderPath As String, ByVal pszSubFolderPath As String, ByVal nSegmentDuration As Long, ByVal bResumeSegmentNum As Boolean, ByVal nSegmentPlaylistCount As Long, ByVal pszWebServerIP  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_RTMP_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword As String, ByVal nNetworkPort_RTMP As Long, ByVal nNetworkPort_RTMPOverHTTP As Long, ByVal pszServerName As String, ByVal pszMediaFolderPath  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_RTMP_SERVER_EX Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword As String, ByVal nNetworkPort_RTMP As Long, ByVal nNetworkPort_RTMPOverHTTP As Long, ByVal pszServerName As String, ByVal pszMediaFolderPath As String, ByVal pszEncryptKey  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal pszURL As String, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal pszURL As String, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword As String, ByVal pszEncryptKey  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal pszURL As String, ByRef ppServer As Long, ByVal pszAccount As String, ByVal pszPassword  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER Lib "QCAP.X86.DLL" _
(ByVal iSvrNum  As Long, ByVal pszURL As String, ByRef ppServer As Long, ByVal pszNetworkAdapterIP As String, ByVal nServiceID As Long, ByVal pszServiceName As String, ByVal pszServiceProviderName As String, ByVal bEnableCBRMode As Boolean, ByVal nTransferBitRate As Long, ByVal nOriginalNetworkID As Long, ByVal nTransportStreamID As Long, ByVal nPMT_PID As Long, ByVal nPCR_PID As Long, ByVal nVideo_PID As Long, ByVal nAudio_PID As Long, ByVal nVideo_CodecID As Long, ByVal nAudio_CodecID As Long, ByVal nPCRInterval  As Long _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_TS_OVER_TCP_SERVER Lib "QCAP.X86.DLL" _
(ByVal iSvrNum  As Long, ByRef ppServer As Long, ByVal nNetworkPort_TCP As Long, ByVal pszNetworkAdapterIP As String, ByVal nServiceID As Long, ByVal pszServiceName As String, ByVal pszServiceProviderName As String, ByVal nTransferBitRate As Long, ByVal nOriginalNetworkID As Long, ByVal nTransportStreamID As Long, ByVal nPMT_PID As Long, ByVal nPCR_PID As Long, ByVal nVideo_PID As Long, ByVal nAudio_PID As Long, ByVal nVideo_CodecID As Long, ByVal nAudio_CodecID As Long, ByVal nPCRInterval  As Long _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_TS_OVER_HTTP_SERVER Lib "QCAP.X86.DLL" _
(ByVal iSvrNum  As Long, ByRef ppServer As Long, ByVal nNetworkPort_HTTP As Long, ByVal pszNetworkAdapterIP As String, ByVal nServiceID As Long, ByVal pszServiceName As String, ByVal pszServiceProviderName As String, ByVal nTransferBitRate As Long, ByVal nOriginalNetworkID As Long, ByVal nTransportStreamID As Long, ByVal nPMT_PID As Long, ByVal nPCR_PID As Long, ByVal nVideo_PID As Long, ByVal nAudio_PID As Long, ByVal nVideo_CodecID As Long, ByVal nAudio_CodecID As Long, ByVal nPCRInterval  As Long _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_TS_OVER_RTP_SERVER Lib "QCAP.X86.DLL" _
(ByVal iSvrNum  As Long, ByVal pszURL As String, ByRef ppServer As Long, ByVal pszNetworkAdapterIP As String, ByVal nServiceID As Long, ByVal pszServiceName As String, ByVal pszServiceProviderName As String, ByVal bEnableCBRMode As Boolean, ByVal nTransferBitRate As Long, ByVal nOriginalNetworkID As Long, ByVal nTransportStreamID As Long, ByVal nPMT_PID As Long, ByVal nPCR_PID As Long, ByVal nVideo_PID As Long, ByVal nAudio_PID As Long, ByVal nVideo_CodecID As Long, ByVal nAudio_CodecID As Long, ByVal nPCRInterval  As Long _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_TS_OVER_TCP_PASSIVE_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal pszURL As String, ByRef ppServer As Long, ByVal nServiceID As Long, ByVal pszServiceName As String, ByVal pszServiceProviderName As String, ByVal nTransferBitRate As Long, ByVal nOriginalNetworkID As Long, ByVal nTransportStreamID As Long, ByVal nPMT_PID As Long, ByVal nPCR_PID As Long, ByVal nVideo_PID As Long, ByVal nAudio_PID As Long, ByVal nVideo_CodecID As Long, ByVal nAudio_CodecID As Long, ByVal nPCRInterval  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_NDI_SERVER Lib "QCAP.X86.DLL" (ByVal iSvrNum  As Long, ByVal pszNDIName As String, ByVal pszGroups As String, ByRef ppServer As Long, ByVal pszConnectionMetadata   As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_DESTROY_BROADCAST_SERVER Lib "QCAP.X86.DLL" (ByVal pServer   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_START_BROADCAST_SERVER Lib "QCAP.X86.DLL" (ByVal pServer   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_STOP_BROADCAST_SERVER Lib "QCAP.X86.DLL" (ByVal pServer   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pDevice As Long, ByVal nSequenceStyle  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pDevice As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle As Long, ByVal nSequenceStyle  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef ppszSessionName As String, ByRef pVideoDelayLiveDuration  As Long, ByRef pAudioDelayLiveDuration    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszSessionName  As String, ByVal nVideoDelayLiveDuration  As Long, ByVal nAudioDelayLiveDuration    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pAttachedWindow As Long, ByRef pThumbDraw As Boolean, ByRef pMaintainAspectRatio As Boolean, ByRef pFlags  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nColorSpaceType As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate As Double, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   hAttachedWindow As Long, ByVal   bThumbDraw As Boolean, ByVal   bMaintainAspectRatio As Boolean, ByVal  dwFlags  As Long _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordProfile  As Long, ByRef pRecordLevel  As Long, ByRef pRecordEntropy  As Long, ByRef pRecordComplexity  As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames  As Long, ByRef pIsInterleaved  As Boolean, ByRef pSlices  As Long _
, ByRef pLayers  As Long, ByRef pSceneCut  As Long, ByRef pMultiThread  As Boolean, ByRef pMBBRC  As Boolean, ByRef pExtBRC  As Boolean, ByRef pMinQP  As Long, ByRef pMaxQP  As Long, ByRef pVBVMaxRate  As Long, ByRef pVBVBufSize  As Long, ByRef pCBRVariation  As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pAttachedWindow As Long, ByRef pThumbDraw As Boolean, ByRef pMaintainAspectRatio As Boolean, ByRef pFlags  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nColorSpaceType As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate As Double, ByVal   nRecordProfile   As Long, ByVal   nRecordLevel   As Long, ByVal   nRecordEntropy   As Long, ByVal   nRecordComplexity   As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nBFrames   As Long, ByVal   bIsInterleaved   As Boolean _
, ByVal   nSlices   As Long, ByVal   nLayers   As Long, ByVal   nSceneCut   As Long, ByVal   bMultiThread   As Boolean, ByVal   bMBBRC   As Boolean, ByVal   bExtBRC   As Boolean, ByVal   nMinQP   As Long, ByVal   nMaxQP   As Long, ByVal   nVBVMaxRate   As Long, ByVal   nVBVBufSize   As Long, ByVal   nCBRVariation   As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY As Long, ByVal   hAttachedWindow As Long, ByVal   bThumbDraw As Boolean, ByVal   bMaintainAspectRatio As Boolean _
, ByVal  dwFlags  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency As Long, ByVal   nBitRate    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pTracks As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nTracks As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency As Long, ByVal   nBitRate    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   iSoundNum    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_SERVER_VOLUME Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pVolume   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_VOLUME Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal   nVolume    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_SERVER_NETWORK_QOS_STATUS Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pIsTransferBusy As Boolean, ByRef pQueueFrames As Long, ByRef pQueueBytes   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_SERVER_NETWORK_QOS_STATUS Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pIsTransferBusy As Boolean, ByRef pQueueFrames As Long, ByRef pQueueBytes   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle As Long, ByVal bForceKeyFrame As Boolean, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nStereoBufferType  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle As Long, ByVal nStereoBufferType  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nStereoDisplayMode As Long, ByVal bLeftRightSwap As Boolean, ByVal bForceKeyFrame As Boolean, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iTrackNum As Long, ByVal iMixNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iTrackNum As Long, ByVal iMixNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iTrackNum As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_BROADCAST_SERVER_COMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iTrackNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_CLEAR_VIDEO_BROADCAST_SERVER_DELAY_LIVE_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal bEnableClear As Boolean, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_CLEAR_AUDIO_BROADCAST_SERVER_DELAY_LIVE_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal bEnableClear As Boolean, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_CLEAR_AUDIO_MX_BROADCAST_SERVER_DELAY_LIVE_BUFFER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iTrackNum As Long, ByVal bEnableClear As Boolean, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_SERVER_BMP Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_SERVER_JPG Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_MOVE_OSD_BROADCAST_SERVER_OBJECT Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY_W Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_TEXT Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_TEXT_W Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nStringAlignmentStyle As Long, ByVal nSequenceStyle As Long _
, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX_W Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_PICTURE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_BUFFER Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long _
, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_SERVER_BUFFER_EX Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long _
, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer , PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer , PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK( PVOID pServer , UINT iSessionNum , PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK( PVOID pServer , UINT iSessionNum , PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_VIDEO_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_AUDIO_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_AUDIO_MX_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK( PVOID pServer , UINT iSessionNum , PF_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );
'
'' BROADCASTING RTSP SERVER EXAMPLE:
''
'' STEP#01 QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 4 , &pServer, "root", "root", 554 );
''
''         CH01 URL -> rtsp://root:root@127.0.0.1:554/session0.mpg
''
''         CH02 URL -> rtsp://root:root@127.0.0.1:554/session1.mpg
''
''         CH03 URL -> rtsp://root:root@127.0.0.1:554/session2.mpg
''
''         CH04 URL -> rtsp://root:root@127.0.0.1:554/session3.mpg
'' 
'' STEP#02 QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 0 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
''
''         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 1 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
''
''         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 2 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
''
''         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 3 , QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 0 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 1 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 2 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 3 , QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
''
'' STEP#03 QCAP_START_BROADCAST_SERVER( pServer );
''
'' STEP#04 QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
''
''         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
''
''         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferC, nFrameBufferLenC );
''
''         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferD, nFrameBufferLenD );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 , pFrameBufferA, nFrameBufferLenA );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 , pFrameBufferB, nFrameBufferLenB );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 , pFrameBufferC, nFrameBufferLenC );
''
''         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 , pFrameBufferD, nFrameBufferLenD );
''
'' STEP#05 QCAP_STOP_BROADCAST_SERVER( pServer );
''
'' STEP#06 QCAP_DRSTROY_BROADCAST_SERVER( pServer );
'
'' BROADCASTING RTMP SERVER EXAMPLE:
''
'' STEP#01 QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 4 , &pServer, NULL, NULL, 1935 );
''
''         CH01 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session0.mpg (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
''
''         CH02 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session1.mpg
''
''         CH03 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session2.mpg
''
''         CH04 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session3.mpg
'
'' BROADCASTING HLS SERVER EXAMPLE:
''
'' STEP#01 QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 4 , &pServer, "C:\\AppServ\\www\\", "hls\\", 3000 ); // HERE, C:\\AppServ\\www\\ IS YOUR WEB SERVER ROOT FOLDER, hls\\ is SUB FOLDER TO SAVE HLS FILES
''
''         CH01 URL -> http://xxx.xxx.xxx.xxx/hls/session0.m3u8 (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
''
''         CH02 URL -> http://xxx.xxx.xxx.xxx/hls/session1.m3u8
''
''         CH03 URL -> http://xxx.xxx.xxx.xxx/hls/session2.m3u8
''
''         CH04 URL -> http://xxx.xxx.xxx.xxx/hls/session3.m3u8
'
'' BROADCASTING UDP SERVER EXAMPLE:
''
'' STEP#01 QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER( 0, "udp://xxx.xxx.xxx.xxx:xxx", &pServer );
'
'' ##########################################################################################################################################################################################
'' #
'' # BROADCASTING CLIENT FUNCTIONS (RTSP/RTMP/TS) (2D/3D)
'' #
'' ##########################################################################################################################################################################################
''
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK)( PVOID pClient , ULONG nTotalStreams , UINT iStreamNum , ULONG nStream_PID , ULONG nProgram_PID , ULONG nVideoWidth , ULONG nVideoHeight , BOOL bVideoIsInterleaved , double dVideoFrameRate , ULONG nAudioChannels , ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , UINT iSessionNum , ULONG nVideoWidth , ULONG nVideoHeight , BOOL bVideoIsInterleaved , double dVideoFrameRate , ULONG nAudioChannels , ULONG nAudioBitsPerSample , ULONG nAudioSampleFrequency , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_FAIL_CALLBACK)( PVOID pClient , UINT iSessionNum , QRESULT nErrorStatus , DWORD nErrorCode , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , QRESULT nErrorStatus , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient , UINT iSessionNum , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , BOOL bIsKeyFrame , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient , UINT iSessionNum , UINT iChNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
Public Declare Function  QCAP_CREATE_BROADCAST_CLIENT Lib "QCAP.X86.DLL" (ByVal iCliNum  As Long, ByVal pszURL As String, ByRef ppClient As Long, ByVal nDecoderType As Long, ByVal hAttachedWindow As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_BROADCAST_CLIENT_EX Lib "QCAP.X86.DLL" (ByVal iCliNum  As Long, ByVal pszURL As String, ByRef ppClient As Long, ByVal nDecoderType As Long, ByVal pszNetworkAdapterIP As String, ByVal hAttachedWindow As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_3D_BROADCAST_CLIENT Lib "QCAP.X86.DLL" (ByVal iCliNum  As Long, ByVal pszURL As String, ByRef ppClient As Long, ByVal nDecoderType As Long, ByVal hAttachedWindowL As Long, ByVal bThumbDrawL As Boolean, ByVal bMaintainAspectRatioL As Boolean, ByVal hAttachedWindowR As Long, ByVal bThumbDrawR As Boolean, ByVal bMaintainAspectRatioR  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_CREATE_3D_BROADCAST_CLIENT_EX Lib "QCAP.X86.DLL" (ByVal iCliNum  As Long, ByVal pszURL As String, ByRef ppClient As Long, ByVal nDecoderType As Long, ByVal pszNetworkAdapterIP As String, ByVal hAttachedWindowL As Long, ByVal bThumbDrawL As Boolean, ByVal bMaintainAspectRatioL As Boolean, ByVal hAttachedWindowR As Long, ByVal bThumbDrawR As Boolean, ByVal bMaintainAspectRatioR  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_DESTROY_BROADCAST_CLIENT Lib "QCAP.X86.DLL" (ByVal pClient   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_START_BROADCAST_CLIENT Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal nProtocol As Long, ByVal nReconnectionTimeout As Long, ByVal nDelayQueueDuration  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_START_BROADCAST_CLIENT_EX Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal nProtocol As Long, ByVal nReconnectionTimeout As Long, ByVal nDelayQueueDuration As Long, ByVal bEnableUltraLowLatency As Boolean, ByVal nAnalyzeDuration As Long, ByVal nProbeDurationSizeKB As Long, ByVal pszEncryptKey  As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_STOP_BROADCAST_CLIENT Lib "QCAP.X86.DLL" (ByVal pClient   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_BROADCAST_CLIENT_OUTPUT_STREAMS Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pVideoStream_PID As Long, ByRef pAudioStream_PID As Long, ByRef pAttachedWindow As Long, ByRef pThumbDraw As Boolean, ByRef pMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_BROADCAST_CLIENT_OUTPUT_STREAMS Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nVideoStream_PID As Long, ByVal nAudioStream_PID As Long, ByVal hAttachedWindow As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_DIAGNOSE_VIDEO_BROADCAST_CLIENT_STREAM_STATUS Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pIsStill As Boolean, ByVal nStillThreshold  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_DIAGNOSE_AUDIO_BROADCAST_CLIENT_STREAM_STATUS Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pVolumeDB_L  As Double, ByRef pVolumeDB_R    As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pStereoDisplayMode As Long, ByRef pLeftRightSwap   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nStereoDisplayMode As Long, ByVal bLeftRightSwap  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pType   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nType   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pEnable   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal bEnable   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pHorizontalMirror As Boolean, ByRef pVerticalMirror   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_CONTRAST Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_CONTRAST Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_HUE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_HUE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_BROADCAST_CLIENT_SATURATION Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_BROADCAST_CLIENT_SATURATION Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByRef pVolume   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal nVolume   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_START_BROADCAST_CLIENT_TIMESHIFT_RECORD Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByRef ppPhysicalFileWriter As Long, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_START_BROADCAST_CLIENT_RECORD Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal dVideoDelayTime As Double, ByVal dAudioDelayTime As Double, ByVal dSegmentDurationTime As Double, ByVal nSegmentDurationSizeKB  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_STOP_BROADCAST_CLIENT_RECORD Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_RESUME_BROADCAST_CLIENT_RECORD Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_PAUSE_BROADCAST_CLIENT_RECORD Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_MOVE_OSD_BROADCAST_CLIENT_OBJECT Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY_W Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_W Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX Lib "QCAP.X86.DLL" _
(ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nStringAlignmentStyle As Long, ByVal nSequenceStyle As Long _
, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX_W Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER Lib "QCAP.X86.DLL" _
(ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long _
, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER_EX Lib "QCAP.X86.DLL" _
(ByVal pClient As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long _
, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal pszProperty As String, ByRef ppszValue   As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal pszProperty As String, ByVal pszValue   As String ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_CONNECTED_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_FAIL_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK( PVOID pClient , PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( PVOID pClient , PF_VIDEO_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( PVOID pClient , PF_AUDIO_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( PVOID pClient , PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( PVOID pClient , PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK( PVOID pClient , PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK pCB , PVOID pUserData  );
'
'' BROADCASTING CLIENT EXAMPLE:
''
'' STEP#01 QCAP_CREATE_BROADCAST_CLIENT( 0, "rtsp://root:root@127.0.0.1:554/session0.mpg", &pClient, QCAP_DECODER_TYPE_SOFTWARE, hWindow, TRUE );
''
'' STEP#02 QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_video_stream, this );
''
''         QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_audio_stream, this );
''
'' STEP#03 QCAP_START_BROADCAST_CLIENT( pClient );
''
'' STEP#04 QCAP_STOP_BROADCAST_CLIENT( pClient );
''
'' STEP#05 QCAP_DESTROY_BROADCAST_CLIENT( pClient );
'
'' ##########################################################################################################################################################################################
'' #
'' # ONVIF COMMUNICATION FUNCTIONS (SERVER/EMULATOR/CLIENT)
'' #
'' ##########################################################################################################################################################################################
''
